 /* 'mrTemplateSet.h' */

 /* Nagowek typw bazowych Mirus */
#include "mrDatatypes.h"
 /* Nagwek definicji bdw Mirus */
#include "mrError.h"
 /* Nagwek obrazu RGBA biblioteki Mirus */
#include "mrRGBAImage.h"
 /* Nagowek ekranu Mirus */
#include "mrScreen.h"
 /* Nagwek tekstury Mirus */
#include "mrTexture.h"

 /* Zaczaj ten plik tylko raz */
#pragma once

 /* Klasa prostoktnego obszaru tesktury Mirus */
class mrRectText
{
public:
 mrReal32         m_fLeft;
 mrReal32         m_fTop;
 mrReal32         m_fRight;
 mrReal32         m_fBottom;
};

 /* Klasa identyfikatora komrki w zestawie szablonw biblioteki Mirus */
class mrCellID
{
public:
 mrUInt32      m_iX;
 mrUInt32      m_iY;
};

 /* Klasa zestawu szablonw Mirus */
class mrTemplateSet
{
protected:
  /* Informacja o teksturze */
 mrTexture *        m_pkTexture;
 mrUInt32           m_iTextureWidth;
 mrUInt32           m_iTextureHeight;

  /* Informacja o komrce */
 mrUInt32           m_iCellWidth;
 mrUInt32           m_iCellHeight;

public:
  /* Konstruktory / Destruktor */
 mrTemplateSet (void);
 ~mrTemplateSet (void);

  /* Procedury manipulujce szablonem */
 void Create (mrTexture * pkTexture, mrUInt32 iTextureWidth, 
              mrUInt32 iTextureHeight, mrUInt32 iCellWidth, 
              mrUInt32 iCellHeight); 

 void GetUV (mrCellID kPosition, mrRectText * pkUVRect);

  /* Procedury obsugowe tekstur */
 void SetActiveTexture (void);

 mrUInt32 GetTextureWidth (void);
 mrUInt32 GetTextureHeight (void);
 mrUInt32 GetCellWidth (void);
 mrUInt32 GetCellHeight (void);
};
